define(['angular', 'app', 'text!version.json'], function (angular, app, version) {
	'use strict';
	app.service('pageService', function ($state, focusService, $http, $q, $filter) {

			var pageService = {};



			pageService.responsive = {
				'primary': '0',
				'secondary': '0'
			};


			pageService.exitPrimaryContent = function (stateName) {
				if (stateName) {
					$state.go(stateName);
				}
				focusService.focusSecondary();
			};

			pageService.getVersionNumber = function () {
				return pageService.version;
			};


			pageService.isRoaAccepted = function (user) {
				var rightOfAccessAccepted = true;
				if (user && user.id) {
					rightOfAccessAccepted = typeof user.rightOfAccessAccepted !== 'undefined' ? user.rightOfAccessAccepted : user.attributes.rightOfAccessAccepted;
				}
				return rightOfAccessAccepted;
			};

			pageService.getRightOfAccessUrl = function () {
				var deferred = $q.defer();
				var servicesPath = $http({
					url: 'resources.json',
					method: 'GET'
				}).success(function(data) {
					var path = $filter('filter')(data.link, {title: 'right-of-access'})[0].href;
					deferred.resolve(path);
				});
				return deferred.promise;
			};



			return pageService;
		});
});